# -*- coding: utf-8 -*-
"""
Created on Tue Jul  7 16:31:35 2020

@author: 909448
"""
#------------------------------------------------------------------------------
#Importing reference
#------------------------------------------------------------------------------

from openpyxl import load_workbook
import numpy as np
import copy as copy
import matplotlib.pyplot as plt
import pandas as pd
import time
from math import radians, cos, sin, asin, sqrt
starttime = time.time()
import winsound
import datetime
import math
from random import seed
from random import randint
seed(1)
from tqdm import tqdm
import random
#------------------------------------------------------------------------------
#parameters
#------------------------------------------------------------------------------

average_car_speed = 110. # [km/h]
max_catchment_area_perimeter = 5. # [hours]
maximum_potential_acc_egg_distance = average_car_speed * max_catchment_area_perimeter
max_acc_egr_time = 0.5

VoT_access     =  67.5
VoT_waiting    =  75
VoT_invehicle  =  50
VoT_transfer   =  50
VoT_egress     =  67.5

w_acc = VoT_access   /  VoT_invehicle 
w_wai = VoT_waiting  /  VoT_invehicle 
w_inv = 1.0
w_trf = VoT_transfer /  VoT_invehicle
w_egr = VoT_egress   /  VoT_invehicle

t_acc  = 0.50
fac_dt = 1
ds_acc = 50
ds_dec = 50
s_crs  = 850
t_dec  = 0.50

t_access_m   =  [0.5, 0.25, 0.0]
t_wait_m     =  [1.8333, 0.5 , 0.0]
t_transfer_m =  [1.5, 1.0 , 0.0]
t_egress_m   =  [0.5, 0.25, 0.0]

t_wait = t_wait_m[0]

lowerboundary_distance = 200.
lowerboundary_duration = 2.

fc_detour = [1., 1.09, 1.20] #plane, HSR, car
vehicle_speed = [850., 220., 110.] #plane, HSR, car

daily_operational_hours = 18.0


a1 = -1 * xxx #utility weight travel time
a2 = +1 * xxx  #utility frequency travel time
a3 = -1 * xxx #utility border crossing travel time

""""---------------------------------------------------------------------------
--------------------------------     STEP 1.    -------------------------------
-----------------------  Construction of true airloads  -----------------------
----------------------------------------------------------------------------"""
#""" Only activated in first run

#location string
location = ([r'H:\#Afstuderen\Demand_Estimation\avia_par_at.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_be.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_bg.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_ch.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_cy.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_de.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_dk.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_ee.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_el.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_es.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_fi.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_fr.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_hr.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_hu.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_ie.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_is.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_it.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_lu.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_lv.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_me.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_mk.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_mt.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_nl.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_no.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_pl.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_pt.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_ro.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_rs.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_se.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_si.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_sk.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_tr.xlsx',
             r'H:\#Afstuderen\Demand_Estimation\avia_par_uk.xlsx'
             
        ])
sheet    = (['avia_par_at', 'avia_par_be', 'avia_par_bg', 'avia_par_ch', 'avia_par_cy', 'avia_par_de', 'avia_par_dk',
             'avia_par_ee', 'avia_par_el', 'avia_par_es', 'avia_par_fi', 'avia_par_fr', 'avia_par_hr', 'avia_par_hu',
             'avia_par_ie', 'avia_par_is', 'avia_par_it', 'avia_par_lu', 'avia_par_lv', 'avia_par_me', 'avia_par_mk',
             'avia_par_mt', 'avia_par_nl', 'avia_par_no', 'avia_par_pl', 'avia_par_pt', 'avia_par_ro', 'avia_par_rs',
             'avia_par_se', 'avia_par_si', 'avia_par_sk', 'avia_par_tr', 'avia_par_uk',
        ])

AP_data  = [['Unit','Msr','ori_CN','ori_AP','des_CN','des_AP','PAX']]
AP_data_freq = [['Unit','Msr','ori_CN','ori_AP','des_CN','des_AP','flights']]
print ''
print 'Extracting flight data as reported by airports:'
with tqdm(total=len(location), desc="Processing", bar_format="{l_bar}{bar} [ time left: {remaining} ]", position=0, leave=True) as pbar:  
    for u in range(len(location)):
        wb           =    load_workbook(location[u])
        ws           =    wb[sheet[u]]
     
        #Load years characteristics
        years = np.array([[i.value for i in j] for j in ws['A1':'LL1']]) 
        XX = np.zeros(len(years[0]), dtype=object)
        for i in range(len(XX)):
            XX[i] = str(copy.copy(years[0,i]))
        years = XX #years
        
        #calculate position of column 2019
        column = np.where(years=='2019')[0][0]
        alphabet = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z']
        
        #build Table
        upperleft = str('A') + str('1')
        lowerright = str(alphabet[column]) + str(ws.max_row)
        Table = np.array([[i.value for i in j] for j in ws[upperleft:lowerright]])
        
        #remove irrelevant columns
        correction = 0
        for column in range(len(Table[0])):
            if Table[0][column - correction] != 'xx':
                if Table[0][column - correction] != '2019':
                    Table = np.delete(Table, column - correction, axis=1)
                    correction = correction + 1
        
        #collect relevant rows
        for row in range(len(Table)):
            if Table[row][0] == 'PAS':
                if Table[row][1] == 'PAS_CRD':
                    AP_data = np.append(AP_data, [Table[row]], axis=0)
            if Table[row][0] == 'FLIGHT':
                if Table[row][1] == 'CAF_PAS':
                    AP_data_freq = np.append(AP_data_freq, [Table[row]], axis=0)
                    
        pbar.update(1)            
        #print 'check', sheet[u], '( loading progress = ', str(round((float(u+1) / len(sheet) * 100),0) )+str('%'),', reached in', int(time.time() - starttime), 'seconds )'       

#save airflow data
print ''
print 'Saving airflow (passengers) data'
df = pd.DataFrame(AP_data)
df.to_excel(excel_writer = "H:/#Afstuderen/Demand_Estimation/AP_data.xlsx")
            
            
#save frequency data
print ''
print 'Saving airflow (frequency) data'          
df = pd.DataFrame(AP_data_freq)
df.to_excel(excel_writer = "H:/#Afstuderen/Demand_Estimation/AP_data_freq.xlsx")

            
#"""
       
""""---------------------------------------------------------------------------
--------------------------------     STEP 2.    -------------------------------
-------------------------  Airflow data modifications  ------------------------
----------------------------------------------------------------------------"""

#""" Only activated in first run

print ''
print 'Loading airflow (passengers) data'
wb_AP_data           =    load_workbook(r'H:\#Afstuderen\Demand_Estimation\AP_data.xlsx')
ws_AP_data           =    wb_AP_data['Sheet1']
AP_data              = np.array([[i.value for i in j] for j in ws_AP_data['B2':'H14174']])  

print ''
print 'Loading airflow (frequency) data'
wb_AP_data_freq           =    load_workbook(r'H:\#Afstuderen\Demand_Estimation\AP_data_freq.xlsx')
ws_AP_data_freq           =    wb_AP_data_freq['Sheet1']
AP_data_freq              =    np.array([[i.value for i in j] for j in ws_AP_data_freq['B2':'H14498']])  

#------------------------------------------------------------------------------
print ''
print 'Altering airport data, removing:'
print '','-','empty links'
print '','-','special airports' 
#remove empty links
correction = 0
for row in range(len(AP_data)):
    if AP_data[row-correction][6] == ': ':
        AP_data = np.delete(AP_data, [row-correction], axis=0)
        correction = correction+1
        
#remove ZZZZ links
correction = 0
for row in range(len(AP_data)):
    if AP_data[row-correction][3] == 'ZZZZ' or AP_data[row-correction][5] == 'ZZZZ':
        AP_data = np.delete(AP_data, [row-correction], axis=0)
        correction = correction+1

#correct for double IACO code of Mulhause-Basel airport
for row in range(len(AP_data)):
    if AP_data[row-correction][3] == 'LSZM':
        AP_data[row-correction][3] = 'LFSB'
    if AP_data[row-correction][5] == 'LSZM':
        AP_data[row-correction][5] = 'LFSB'
        
#correct for double IACO code of Mulhause-Basel airport
for row in range(len(AP_data_freq)):
    if AP_data_freq[row-correction][3] == 'LSZM':
        AP_data_freq[row-correction][3] = 'LFSB'
    if AP_data_freq[row-correction][5] == 'LSZM':
        AP_data_freq[row-correction][5] = 'LFSB'
    
print ''
print 'Identifying remaining airports and countries'
#make list of unique airports and countries
set_of_airports = set() 
set_of_countries = set()

for row in range(len(AP_data)-1):
    set_of_airports.add(AP_data[row+1][3])
    set_of_airports.add(AP_data[row+1][5])
    set_of_countries.add(AP_data[row+1][2])
    set_of_countries.add(AP_data[row+1][4])

N_airports  =  len(set_of_airports)
N_countries =  len(set_of_countries)

list_AP_temp = sorted(list(set_of_airports))
list_CN_temp = sorted(list(set_of_countries))

list_of_airports = np.zeros(N_airports, dtype=object)
list_of_countries = np.zeros(N_countries, dtype=object)

for n in range(N_airports):
    list_of_airports[n] = list_AP_temp[n]
for n in range(N_countries):
    list_of_countries[n] = list_CN_temp[n]

#load airport characteristics 
print ''
print 'Loading airport characteristics'
print '','-','categorical: ICAO and IATA codes and names'  
print '','-','topographical: continent, country, municipality' 
print '','-','geographical: latitude, longitude' 

wb_AP_info           =    load_workbook(r'H:\#Afstuderen\Demand_Estimation\airportinformation3.xlsx')
ws_AP_info           =    wb_AP_info['airportdata']

#specify specific characteristics
ICAO = np.array([[i.value for i in j] for j in ws_AP_info['B1':'GPG1']]) 
XX = np.zeros(len(ICAO[0]), dtype=object)
for i in range(len(XX)):
    XX[i] = str(copy.copy(ICAO[0,i]))
ICAO = XX #years

name = np.array([[i.value for i in j] for j in ws_AP_info['B2':'GPG2']]) 
XX = np.zeros(len(name[0]), dtype=object)
for i in range(len(XX)):
    XX[i] = str(copy.copy(name[0,i]))
name = XX #years

continent = np.array([[i.value for i in j] for j in ws_AP_info['B3':'GPG3']]) 
XX = np.zeros(len(continent[0]), dtype=object)
for i in range(len(XX)):
    XX[i] = str(copy.copy(continent[0,i]))
continent = XX #years

country = np.array([[i.value for i in j] for j in ws_AP_info['B4':'GPG4']]) 
XX = np.zeros(len(country[0]), dtype=object)
for i in range(len(XX)):
    XX[i] = copy.copy(country[0,i])
country = XX #years

municipality = np.array([[i.value for i in j] for j in ws_AP_info['B5':'GPG5']]) 
XX = np.zeros(len(municipality[0]), dtype=object)
for i in range(len(XX)):
    XX[i] = str(copy.copy(municipality[0,i]))
municipality = XX #years

IATA = np.array([[i.value for i in j] for j in ws_AP_info['B7':'GPG7']]) 
XX = np.zeros(len(IATA[0]), dtype=object)
for i in range(len(XX)):
    XX[i] = str(copy.copy(IATA[0,i]))
IATA = XX #years

AP_lon = np.array([[i.value for i in j] for j in ws_AP_info['B8':'GPG8']]) 
XX = np.zeros(len(AP_lon[0]))
for i in range(len(XX)):
    XX[i] = str(copy.copy(AP_lon[0,i]))
AP_lon = XX #years

AP_lat = np.array([[i.value for i in j] for j in ws_AP_info['B9':'GPG9']]) 
XX = np.zeros(len(AP_lat[0]))
for i in range(len(XX)):
    XX[i] = str(copy.copy(AP_lat[0,i]))
AP_lat = XX #years

airport_information = np.full((N_airports, 8),'n/a', dtype=object) #[ICAO, IATA, name, cont, coun, muni, AP_lat, AP_lon]

#fill airport information row
for row in range(len(list_of_airports)):
    airport_information[row][0] = list_of_airports[row]
    for column in range(len(name)):
        if ICAO[column] == airport_information[row][0]:
            airport_information[row][1] = IATA[column]
            airport_information[row][2] = name[column]
            airport_information[row][3] = continent[column]
            airport_information[row][4] = country[column]
            airport_information[row][5] = municipality[column]
            airport_information[row][6] = AP_lat[column]
            airport_information[row][7] = AP_lon[column]

#sort list on (1) continents, (2) countries, (4) cities
airport_information2 = copy.deepcopy(airport_information)
airport_information2 = sorted(airport_information2 ,key=lambda x: x[5])
airport_information2 = sorted(airport_information2 ,key=lambda x: x[4])
airport_information2 = sorted(airport_information2 ,key=lambda x: x[3])
airport_information = copy.deepcopy(airport_information2)

#update the sequence of list_of_airports in ICAO codes
for n in range(N_airports):
    list_of_airports[n] = airport_information[n][0]

#delete rows from frequency data between airports not in AP_data set to prevent further error
correction=0
for row in range(len(AP_data_freq)-1):
    if AP_data_freq[row+1-correction][3] not in list(list_of_airports) or AP_data_freq[row+1-correction][5] not in list(list_of_airports):
        AP_data_freq = np.delete(AP_data_freq, row+1-correction, axis = 0)
        correction = correction + 1

#define AP list locator
def APnum(a): #finds AP index number
    return np.where(list_of_airports==a)[0][0]

#------------------------------------------------------------------------------
    
#Combine aiport characteristics and flows into one matrix
print ''
print 'Combine aiport characteristics and flows into one matrix'

#build OD_matrix
OD_matrix      = np.zeros((len(list_of_airports), len(list_of_airports)),dtype=object)
OD_matrix_freq = np.zeros((len(list_of_airports), len(list_of_airports)),dtype=object)

#fill OD matrix with flight data (passengers)
for row in range(len(AP_data)-1):
    j = APnum(AP_data[row+1][3])
    i = APnum(AP_data[row+1][5])
    pax = float(AP_data[row+1][6])
    OD_matrix[i,j] = pax
    
#fill OD matrix with flight data (frequency)
for row in range(len(AP_data_freq)-1):
    j = APnum(AP_data_freq[row+1][3])
    i = APnum(AP_data_freq[row+1][5])
    freq_y = AP_data_freq[row+1][6]
    if freq_y == ': ':
        freq_y = 0
    OD_matrix_freq[i,j] = float(freq_y) / 365. #from yearly to daily
    if freq_y == 0 and OD_matrix[i,j] > 0:
        OD_matrix_freq[i,j] = -1 * float('inf')

#fill mirrored matrix, to make it more complete and symmetrical (passengers)
mirror_matrix = np.zeros((len(list_of_airports), len(list_of_airports)),dtype=object)
for i in range(len(mirror_matrix)):
    for j in range(len(mirror_matrix)):
        mirror_matrix[i,j] = (np.maximum(OD_matrix[i,j], OD_matrix[j,i]))/2.0
        mirror_matrix[j,i] = copy.copy(mirror_matrix[i,j])

#fill mirrored matrix, to make it more complete and symmetrical (frequency)
mirror_matrix_freq = np.zeros((len(list_of_airports), len(list_of_airports)),dtype=object)
for i in range(len(mirror_matrix_freq)):
    for j in range(len(mirror_matrix_freq)):
        mirror_matrix_freq[i,j] = (np.maximum(OD_matrix_freq[i,j], OD_matrix_freq[j,i]))/2.0
        mirror_matrix_freq[j,i] = copy.copy(mirror_matrix_freq[i,j])
        if mirror_matrix_freq[i,j] < 0:
            mirror_matrix_freq[i,j] = 'n/a'; mirror_matrix_freq[j,i] = 'n/a'
        if mirror_matrix_freq[i,j] == 0:
            mirror_matrix_freq[i,j] = ':'; mirror_matrix_freq[j,i] = ':'

#summate rows
sum_vertical = np.zeros((len(list_of_airports),1))
sum_vertical_mirror = np.zeros((len(list_of_airports),1))
for i in range(len(list_of_airports)):
   sum_vertical[i] = np.sum(OD_matrix[i,:])
   sum_vertical_mirror[i] = np.sum(mirror_matrix[i,:])

#summate columns
sum_horizontal = np.zeros((1,len(list_of_airports)))
sum_horizontal_mirror = np.zeros((1,len(list_of_airports)))
for j in range(len(list_of_airports)):
   sum_horizontal[:,j] = np.sum(OD_matrix[:,j])
   sum_horizontal_mirror[:,j] = np.sum(mirror_matrix[:,j])       

#make zero values to ':', because they are unknown rather then '0'.
for i in range(len(OD_matrix)):
    for j in range(len(OD_matrix)):
        if OD_matrix[i,j] == 0:
            OD_matrix[i,j] = ':'
        if mirror_matrix[i,j] == 0:
            mirror_matrix[i,j] = ':' 

#save an original version of the airport information array
airport_information_OG = copy.copy(airport_information)

#construct total output matrix
total_matrix = np.append(sum_vertical, OD_matrix, axis=1)
total_matrix = np.append(airport_information, total_matrix, axis=1)
airport_information = np.transpose(airport_information)
airport_information = np.append(airport_information, sum_horizontal, axis=0)
left_hand_corner = np.full((len(airport_information),len(airport_information)),'', dtype=object)
upper_bar = np.append(left_hand_corner, airport_information, axis=1)
total_matrix = np.append(upper_bar, total_matrix, axis=0)
airport_information = copy.copy(airport_information_OG)

#export total_matrix to excel
print ''
print 'Saving total matrix'
df = pd.DataFrame(total_matrix).T
df.to_excel(excel_writer = "H:/#Afstuderen/Demand_Estimation/DM_air_matrix.xlsx")

#construct total output matrix which is mirrored
total_mirror_matrix = np.append(sum_vertical_mirror, mirror_matrix, axis=1)
total_mirror_matrix  = np.append(airport_information, total_mirror_matrix , axis=1)
airport_information = np.transpose(airport_information)
airport_information = np.append(airport_information, sum_horizontal_mirror, axis=0)
left_hand_corner_mirror = np.full((len(airport_information),len(airport_information)),'', dtype=object)
upper_bar_mirror = np.append(left_hand_corner_mirror, airport_information, axis=1)
total_mirror_matrix  = np.append(upper_bar_mirror, total_mirror_matrix , axis=0)
airport_information = copy.copy(airport_information_OG)

#export matrix to excel
print ''
print 'Saving mirrored matrix'
df = pd.DataFrame(total_mirror_matrix).T
df.to_excel(excel_writer = "H:/#Afstuderen/Demand_Estimation/DM_air_matrix_mirror.xlsx")
            
#export total_matrix to excel
print ''
print 'Saving total frequency matrix'
df = pd.DataFrame(OD_matrix_freq).T
df.to_excel(excel_writer = "H:/#Afstuderen/Demand_Estimation/freq_air_matrix.xlsx")
            
#export matrix to excel
print ''
print 'Saving mirrored frequency matrix'
df = pd.DataFrame(mirror_matrix_freq).T
df.to_excel(excel_writer = "H:/#Afstuderen/Demand_Estimation/freq_air_matrix_mirror.xlsx")
            
      
#"""             

""""---------------------------------------------------------------------------
--------------------------------     STEP 3.    -------------------------------
----------------------  Find access and egress distances ----------------------
------------------------  between  cities and airports ------------------------
----------------------------------------------------------------------------"""

#""" Only activated in first run

#remove non European and non-identified airports from further analyis 
print ''
print 'Altering airport data, removing:'
print '', '-', 'non-European (continent + Russia & Turkey) airports' 

correction=0
for x in range(len(airport_information)):   
    if airport_information[x-correction][3] != 'Europe':
        airport_information = np.delete(airport_information, x-correction, axis = 0)
        mirror_matrix = np.delete(mirror_matrix, x-correction, axis = 0)
        mirror_matrix = np.delete(mirror_matrix, x-correction, axis = 1)
        mirror_matrix_freq = np.delete(mirror_matrix_freq, x-correction, axis = 0)
        mirror_matrix_freq = np.delete(mirror_matrix_freq, x-correction, axis = 1)
        correction = correction + 1
#import core cities
print ''
print 'Loading core European railway network cities' 
wb           =    load_workbook(r'H:\#Afstuderen\Demand_Estimation\#Core_cities_geography.xlsx')
ws_vertices  =    wb['Duration_road']

length_V = 125
range_len_V = range(125)

V = np.array([[i.value for i in j] for j in ws_vertices['F2':'DZ2']]) 
XX = np.zeros(length_V, dtype=object)
for i in range(len(XX)):
    XX[i] = V[0,i]
V = XX #vertex latitudes

V_country = np.array([[i.value for i in j] for j in ws_vertices['F1':'DZ1']]) 
XX = np.zeros(length_V, dtype=object)
for i in range(len(XX)):
    XX[i] = V_country[0,i]
V_country = XX #vertex latitudes

V_pop = np.array([[i.value for i in j] for j in ws_vertices['F3':'DZ3']]) 
XX = np.zeros(length_V)
for i in range(len(XX)):
    XX[i] = V_pop[0,i]
V_pop = XX #vertex populations

V_lat = np.array([[i.value for i in j] for j in ws_vertices['F4':'DZ4']]) 
XX = np.zeros(length_V)
for i in range(len(XX)):
    XX[i] = V_lat[0,i]
V_lat = XX #vertex latitudes

V_lon = np.array([[i.value for i in j] for j in ws_vertices['F5':'DZ5']]) 
XX = np.zeros(length_V)
for i in range(len(XX)):
    XX[i] = V_lon[0,i]
V_lon = XX #vertex longitudes 

#sort latitudes and longitudes based on airport information list
AP_lat = np.zeros((len(airport_information)))
AP_lon = np.zeros((len(airport_information)))
for row in range(len(AP_lon)):
    AP_lat[row] = airport_information[row][6]
    AP_lon[row] = airport_information[row][7]
    
#build OD matrices for airport to city
CI_to_AP_DSgc = np.zeros((len(V), len(airport_information))) #greater circle distance
CI_to_AP_dura = np.zeros((len(V), len(airport_information))) #duration by car

#define haversine formula
def haversine(lat_i, lon_i, lat_j, lon_j):

    # convert decimal degrees to radians 
    lat_i, lon_i, lat_j, lon_j = map(radians, [lat_i, lon_i, lat_j, lon_j])

    # haversine formula 
    lat_delta = (lat_j - lat_i) 
    lon_delta = (lon_j - lon_i) 
    sr = sqrt(sin(lat_delta/2)**2 + cos(lat_i) * cos(lat_j) * sin(lon_delta/2)**2)
    R_earth = 6371.000 #radius earth [m]
    ds_gc = R_earth * 2 * asin(sr)
    return ds_gc #[km]

#calculate greater circle distances matrix
print ''
print 'build city-to-airport distance matrix' 
for i in range(len(CI_to_AP_DSgc)):
    for j in range(len(CI_to_AP_DSgc[0])):
        CI_to_AP_DSgc[i,j] = haversine(V_lat[i],V_lon[i],airport_information[:,6][j],airport_information[:,7][j])

df = pd.DataFrame(CI_to_AP_DSgc)
df.to_excel(excel_writer = "H:/#Afstuderen/Demand_Estimation/CI_to_AP_DSgc.xlsx")
            
#"""            
            
""""---------------------------------------------------------------------------
--------------------------------     STEP 4.    -------------------------------
------------------------  Find access and egress times ------------------------
------------------------  between  cities and airports ------------------------
----------------------------------------------------------------------------"""
  
""" Only activated when working with a new city / airport database

print ''
print 'Start city-to-airport duration API (OpenRouteService)' 

#define infeasible city-airport combinations
for i in range(len(CI_to_AP_DSgc)):
    for j in range(len(CI_to_AP_DSgc[0])):
        if CI_to_AP_DSgc[i,j] > maximum_potential_acc_egg_distance:
            CI_to_AP_dura[i,j] = float('inf')
'''
#export duration matrix to allow for in-between saving
df = pd.DataFrame(CI_to_AP_dura)
df.to_excel(excel_writer = "C:/Users/909448/Documents/##AFSTUDEREN/modelling/Netwerk/CI_to_AP_dura.xlsx")
'''
            
wb           =    load_workbook(r'C:\Users\909448\Documents\##AFSTUDEREN\modelling\netwerk\CI_to_AP_dura.xlsx')
ws  =    wb['Sheet1']
CI_to_AP_dura = np.array([[i.value for i in j] for j in ws['B2':'NV126']],dtype=object)

#determine access and egress times
saver = 0
counter = 0
for v in range(len(CI_to_AP_dura)):
    for ap in range(len(CI_to_AP_dura[0])):
        if CI_to_AP_dura[v,ap] < 0.000001:
            print ''
            print 'from',v,V[v], '(city) to' , ap,airport_information[:,5][ap],'(airport)',
            randomizer = randint(0, 2)
            if randomizer == 0:
                coords = ((V_lon[v],V_lat[v]), (airport_information[:,7][ap],airport_information[:,6][ap]))
                client = openrouteservice.Client(key='5b3ce3597851110001cf624817a8f76f48fe4097929168d3af658174') # Specify your personal API key
                routes = client.directions(
                    coordinates=coords,
                    profile='driving-car',
                    radiuses=[4000,4000],
                    format='geojson',
                    validate=False,
                )
            if randomizer == 1:
                coords = ((V_lon[v],V_lat[v]), (airport_information[:,7][ap],airport_information[:,6][ap]))
                client = openrouteservice.Client(key='5b3ce3597851110001cf62483b780fd5c5dd455da89cc2eaa17543d8') # Specify your personal API key
                routes = client.directions(
                    coordinates=coords,
                    profile='driving-car',
                    radiuses=[4000,4000],
                    format='geojson',
                    validate=False,
                )
            if randomizer == 2:
                coords = ((V_lon[v],V_lat[v]), (airport_information[:,7][ap],airport_information[:,6][ap]))
                client = openrouteservice.Client(key='5b3ce3597851110001cf62481e0b82020ae745c2ae7b6642eabcc7a9') # Specify your personal API key
                routes = client.directions(
                    coordinates=coords,
                    profile='driving-car',
                    radiuses=[4000,4000],
                    format='geojson',
                    validate=False,
                )
            #print routes['features'][0]['properties']['segments'][0]['duration']/60/60
            if routes['features'][0]['properties']['segments'][0]['duration']/60/60 < max_catchment_area_perimeter:
                CI_to_AP_dura[v,ap] = routes['features'][0]['properties']['segments'][0]['duration']/60/60
            else:
                CI_to_AP_dura[v,ap] = float('inf')
            counter = counter+1
            saver = saver+1
            print counter, '(',v,',',ap,')'#,coords
            if saver == 19:
                df_dur = pd.DataFrame(CI_to_AP_dura)
                df_dur.to_excel(excel_writer = "C:/Users/909448/Documents/##AFSTUDEREN/modelling/Netwerk/CI_to_AP_dura.xlsx")
                saver = 0
                print 'SAVE...'
                duration = 500  # milliseconds
                freq = 261  # Hz
                winsound.Beep(freq, duration)
                time.sleep(0.5)
                duration = 500  # milliseconds
                freq = 329  # Hz
                winsound.Beep(freq, duration)
                time.sleep(0.5)
                duration = 500  # milliseconds
                freq = 392  # Hz
                winsound.Beep(freq, duration)
                time.sleep(3)
                
df_dur = pd.DataFrame(CI_to_AP_dura)
df_dur.to_excel(excel_writer = "C:/Users/909448/Documents/##AFSTUDEREN/modelling/Netwerk/CI_to_AP_dura.xlsx")
          
df_dur = pd.DataFrame(airport_information)
df_dur.to_excel(excel_writer = "C:/Users/909448/Documents/##AFSTUDEREN/modelling/Netwerk/airport_information.xlsx")

"""

#""" #only activated in first run
print ''
print 'loading city-to-airport duration matrix'
wb           =    load_workbook(r'H:\#Afstuderen\Demand_Estimation\CI_to_AP_dura.xlsx')
ws  =    wb['Sheet1']
CI_to_AP_dura = np.array([[i.value for i in j] for j in ws['B2':'NV126']],dtype=object)
#"""

""""---------------------------------------------------------------------------
--------------------------------     STEP 5.    -------------------------------
----------------------  Make inventory of flight options ----------------------
----------------------------------------------------------------------------"""

#""" Only activated in first run

print ''
print 'Loading distance by road between city centres' 
wb_road_distances  =    load_workbook(r'H:\#Afstuderen\Demand_Estimation\#Core_cities_geography.xlsx')
ws_road_distances  =    wb_road_distances['Distance_road']
road_distance = np.array([[i.value for i in j] for j in ws_road_distances['F6':'DZ130']], dtype=float)

print ''
print 'Loading duration by road between city centres' 
wb_road_duration  =    load_workbook(r'H:\#Afstuderen\Demand_Estimation\#Core_cities_geography.xlsx')
ws_road_duration  =    wb_road_distances['Duration_road']
road_duration = np.array([[i.value for i in j] for j in ws_road_duration['F6':'DZ130']], dtype=float)

#------------------------------------------------------------------------------

print ''
print 'Calulating flight times between airports'
def func_t_inv_air(ds_gc_ij):
    
    t_inv_air = t_acc + (ds_gc_ij * fac_dt - ds_acc - ds_dec) / (s_crs) + t_dec #in-vehcile time per airplane edge
    
    return t_inv_air #in-vehicle time car [h]

T_inv_air = np.full((len(mirror_matrix), len(mirror_matrix)), float('inf'))
for i in range(len(airport_information)):
    for j in range(len(airport_information)):
        if mirror_matrix[i,j] != ':':
            AP_to_AP_dis_gc = haversine(AP_lat[i],AP_lon[i],AP_lat[j],AP_lon[j])
            T_inv_air[i,j] = func_t_inv_air(AP_to_AP_dis_gc)
            
#verification of flight duration  
#print airport_information[192][0], airport_information[367][0], str(datetime.timedelta(seconds=T_inv_air[192,367]*60*60))
#print airport_information[192][0], airport_information[286][0], str(datetime.timedelta(seconds=T_inv_air[192,286]*60*60))
#print airport_information[192][0], airport_information[265][0], str(datetime.timedelta(seconds=T_inv_air[192,265]*60*60))
#print airport_information[192][0], airport_information[281][0], str(datetime.timedelta(seconds=T_inv_air[192,281]*60*60))

#construction flight possibilities for each city-to-city OD pair
print ''
print 'Identify cities within airport.s catchment areas'                      
#build scatter lists for each city V
scatter_list_CI_to_AP = np.zeros((length_V,1), dtype=object)
for v in range_len_V:
    scatter_AP = list()
    for ap in range(len(airport_information)):
        if CI_to_AP_dura[v][ap] != 'inf' and CI_to_AP_dura[v][ap] < max_acc_egr_time :
            scatter_AP = np.append(scatter_AP, ap, axis=None)
    #print v, V[v], scatter_AP
    scatter_list_CI_to_AP[v][0] = scatter_AP

#build flight-options
print ''
print 'Identify flying path possibilities per core city pair'   
flight_options = np.zeros((length_V, length_V), dtype=object)
for i in range_len_V:
    for j in range_len_V:
        if i != j:
            flight_options[i,j] = np.zeros((len(scatter_list_CI_to_AP[i][0]),len(scatter_list_CI_to_AP[j][0])))

for i in range_len_V:
    for j in range_len_V: 
        if i != j:
            for x in range(len(flight_options[i,j])):
                for y in range(len(flight_options[i,j][0])):
                    ap1 = int(scatter_list_CI_to_AP[i][0][x])
                    ap2 = int(scatter_list_CI_to_AP[j][0][y])
                    flight_options[i,j][x,y] = T_inv_air[ap1,ap2]
#"""

""""---------------------------------------------------------------------------
--------------------------------     STEP 6.    -------------------------------
--------------------------  Comparison to other modes -------------------------
----------------------------------------------------------------------------"""


def func_t_trip_air_weighted(t_access,t_wait,t_in_vehicle,t_egress):

    t_trip_air = (t_access*w_acc) + (t_wait*w_wai) + (t_in_vehicle*w_inv) + (t_egress*w_egr) #no transfers needed

    return t_trip_air #[h]

def func_t_trip_air_estimated(i,j,t_access,t_wait,t_in_vehicle,t_egress):

    t_trip_air_estimated = (t_access*w_acc) + (t_wait*w_wai) + (t_in_vehicle*w_inv) + (t_egress*w_egr) #no transfers needed

    return t_trip_air_estimated #[h]

def func_t_trip_car_estimated(i,j):

    t_trip_car_estimated = (road_duration[i,j]*w_inv)

    return t_trip_car_estimated #[h]

def func_modalsplit_estimate_air(tt_air,tt_car): #find mode specific regret values
    
    #Regret value determination
    R_air  = np.log(1.0 + math.e**(-0.01 * 60 * (tt_car - tt_air))) - np.log(2)
    R_car  = np.log(1.0 + math.e**(-0.01 * 60 * (tt_air - tt_car))) - np.log(2)

    #Mode probability determination
    P_air  = math.e**(-R_air) / (math.e**(-R_air) + math.e**(-R_car))
    
    return P_air

#modal split calculation (random regret based)

def func_regret(trip_time,trip_surrounding): #find flight specific regret values
    
    dif_sum = 0
    for tt_x in range(len(trip_surrounding)):
        dif = math.e**(-0.01 * 60 * (float(trip_surrounding[tt_x])- float(trip_time)))
        dif_sum = dif_sum + dif
    R = np.log( 1.0 + dif_sum ) - np.log(2)
    return R

def func_probability(R_x,R_sum_x): #find flight specific probabilities
    
    P = math.e**(-1 * float(R_x)) / float(R_sum_x)
    
    return P 


def func_utility_flight(tt_a, tt_e, DST, BC_ap1, BC_ap2): #find flight specific probabilities
    
    U = a1*( ( tt_a*(a2*BC_ap1))*(tt_e*(a2*BC_ap2) ) ) + (a3*DST)
    
    return U 

def func_utility_maximisation_probability(V_x,V_sum_x): #find flight specific probabilities
    
    P = math.e**(float(V_x)) / float(V_sum_x)
    
    return P 

""""---------------------------------------------------------------------------
--------------------------------     STEP 7.    -------------------------------
--------------------  Construction of connectivity list -----------------------
-----------------------------------------------------------------------------"""

#""" Only actived when adjusting certain parameters

#make average flight duration matrix
Matrix_avg_flight = np.full((length_V, length_V), float('inf')) 

#make connectivity list
print ''
print 'Building connectivity list, including:'
print '','-','origin city, origin airport, destination airport, destination city'
print '','-','access times, egress times, flight duration'
print '','-','weighted travel times, according to VoT'
print '','-','relative regret value, propability of path choice and potential'
connectivity_list = [['i','access','ap1','flight','ap2','egress','j','dur_tot','dur_tot_wei','R','P','potential','pax','pax_ij_tot','marketshare_ij','freq','cb_ap1','cb_ap2','Utility', 'prob. MNL']]
with tqdm(total=length_V, desc="Processing", bar_format="{l_bar}{bar} [ time left: {remaining} ]", position=0, leave=True) as pbar:
    for i in range_len_V:
        pbar.update(1)
        for j in range_len_V: 
            if i != j:
                #if (i == 109 and j == 122) or (i == 112 and j == 122) :
                if 1 == 1:
                    if road_distance[i,j] > lowerboundary_distance or road_duration[i,j] > lowerboundary_duration:
                        #make list of feasible routes
                        feasible_routes = list()
                        for x in range(len(flight_options[i,j])):
                            for y in range(len(flight_options[i,j][0])):
                                #fill in already available data concerning feasible trip characteristics
                                if flight_options[i,j][x,y] != float('inf'):
                                    trip = [i,'t_acc',int(scatter_list_CI_to_AP[i][0][x]),flight_options[i,j][x,y],int(scatter_list_CI_to_AP[j][0][y]),'t_egr',j,'t_tot', 't_weight','R', 'P', 'pot', 'pax','pax_ij_tot','marketshare_ij','freq',0.0,0.0,'Utility', 'prob. MNL']
                                    trip[1] = CI_to_AP_dura[i,trip[2]]
                                    trip[5] = CI_to_AP_dura[j,trip[4]]
                                    trip[7] = trip[1] + trip[3] + trip[5] + t_wait
                                    trip[8] = func_t_trip_air_weighted(trip[1],t_wait,trip[3],trip[5])
                                    trip[15] = mirror_matrix_freq[trip[2],trip[4]]
                                    if V_country[int(trip[0])] != airport_information[trip[2]][4]:
                                        trip[16] = 1.0 
                                    if airport_information[trip[4]][4] != V_country[int(trip[6])]:
                                        trip[17] = 1.0
                                    #append this trip to the list of feasbile routes
                                    if len(feasible_routes) == 0:
                                        feasible_routes = [trip]
                                    else:
                                        feasible_routes = np.append(feasible_routes, [trip], axis=0)
                        #calculate regret value
                        if len(feasible_routes) > 1:
                            #print ''
                            for trip in range(len(feasible_routes)):
                                trip_time = feasible_routes[trip,8]   
                                trip_surrounding = np.delete(feasible_routes[:,8], trip)
                                R = func_regret(trip_time,trip_surrounding)
                                feasible_routes[trip,9] = R
                                tt_a = float(feasible_routes[trip,1])
                                tt_e = float(feasible_routes[trip,5])
                                if feasible_routes[trip,15] == 'n/a': #estimate value when frequency is missing
                                    feasible_routes[trip,15] = mirror_matrix[int(feasible_routes[trip,2]),int(feasible_routes[trip,4])] / 365 / 150 #150 estimate average flight
                                if feasible_routes[trip,15] == ':': #estimate value when frequency is missing
                                    feasible_routes[trip,15] = mirror_matrix[int(feasible_routes[trip,2]),int(feasible_routes[trip,4])] / 365 / 150 #150 estimate average flight
                                DST = (daily_operational_hours / float(feasible_routes[trip,15])) / 4.0
                                BC_ap1 = float(feasible_routes[trip,16]) 
                                BC_ap2 = float(feasible_routes[trip,17])
                                U = func_utility_flight(tt_a, tt_e, DST, BC_ap1, BC_ap2)
                                feasible_routes[trip,18] = U
                            #summate R value as preparation for P calculations
                            R_sum_x = 0
                            for trip in range(len(feasible_routes)):
                                R_sum_x = R_sum_x + math.e**(-1 * float(feasible_routes[trip,9]))
                                
                            U_sum_x = 0
                            for trip in range(len(feasible_routes)):
                                U_sum_x = U_sum_x + math.e**(float(feasible_routes[trip,18]))
                                #print '(',round(float(feasible_routes[trip,8]),1), round(float(feasible_routes[trip,15]),1), int(float(feasible_routes[trip,16]) + float(feasible_routes[trip,17])),')' ,
                            #print ''
                            #calculate probability value
                            for trip in range(len(feasible_routes)):
                                p = func_probability(feasible_routes[trip,9],R_sum_x)
                                feasible_routes[trip,10] = p
                                #print round(p,3),
                            #print ''
                            for trip in range(len(feasible_routes)):
                                p_mnl = func_utility_maximisation_probability(feasible_routes[trip,18],U_sum_x)
                                feasible_routes[trip,19] = p_mnl
                                #print round(p_mnl,3),
                            #print ''
                            #calculate average flight trip
                            flight_avg = [0,t_wait_m[0],0,0] #'t_access',t_wait,'t_inv','t_egress'
                            for trip in range(len(feasible_routes)):
                                flight_avg[0] = flight_avg[0] + (float(feasible_routes[trip,1]) * float(feasible_routes[trip,19])) #access time * probability
                                flight_avg[2] = flight_avg[2] + (float(feasible_routes[trip,3]) * float(feasible_routes[trip,19])) #inv. time * probability
                                flight_avg[3] = flight_avg[3] + (float(feasible_routes[trip,5]) * float(feasible_routes[trip,19])) #egress * probability
                            #estimate travel times using other modes
                            tt_air  = func_t_trip_air_estimated(i, j, flight_avg[0], flight_avg[1], flight_avg[2], flight_avg[3] )
                            tt_car  = func_t_trip_car_estimated(i, j                                                             )
                            #save average flight time for later works
                            Matrix_avg_flight[i,j] = tt_air
                            #estimate modal split for air travel when comparing to other modes
                            MS_air_estimate = func_modalsplit_estimate_air(tt_air,tt_car)
                            #translate probability into potential
                            for trip in range(len(feasible_routes)):
                                potential = MS_air_estimate * ( V_pop[i] * V_pop[j] ) / (road_distance[i,j] / fc_detour[2]) * float(feasible_routes[trip,10])
                                feasible_routes[trip,11] = potential
                            #append trip data to connectivity list
                            for trip in range(len(feasible_routes)):
                                connectivity_list = np.append(connectivity_list, [feasible_routes[trip]], axis=0)
                        if len(feasible_routes) == 1:
                            #give values to R and P
                            feasible_routes[0][9] = 1.00
                            feasible_routes[0][10] = 1.00
                            #define only flight as average flight
                            flight_avg = [float(feasible_routes[0][1]),t_wait_m[0],float(feasible_routes[0][3]),float(feasible_routes[0][5])]
                            #define competing travel times 
                            tt_air  = func_t_trip_air_estimated( i, j, flight_avg[0], flight_avg[1], flight_avg[2], flight_avg[3] )
                            tt_car  = func_t_trip_car_estimated( i, j                                                             )
                            #save average flight time for later works
                            Matrix_avg_flight[i,j] = tt_air
                            #estimate modal split for air travel when comparing to other modes
                            MS_air_estimate = func_modalsplit_estimate_air(tt_air,tt_car)
                            #translate probability into potential
                            feasible_routes[0][11] = MS_air_estimate * ( V_pop[i] * V_pop[j] ) / (road_distance[i,j] / fc_detour[2]) 
                            #append trip data to connectivity list
                            connectivity_list = np.append(connectivity_list, [feasible_routes[0]], axis=0)
                            #print MS_air_estimate
            
#delete header row from connectivity list in order to calculate on it
connectivity_list = np.delete(connectivity_list, 0, axis = 0)

print Matrix_avg_flight[109,122]
#"""

""""---------------------------------------------------------------------------
--------------------------------     STEP 8.    -------------------------------
--------------------------  translation to air demand -------------------------
-----------------------------------------------------------------------------"""

#make airport numbers integers again
DEMAND_AIR = np.zeros((length_V, length_V))
Matrix_avg_flight_2 = np.zeros((length_V, length_V), dtype=object)
for i in range_len_V:
    for j in range_len_V:
        Matrix_avg_flight_2[i,j] = [0,0,0,0,0,0] #'t_access',t_wait,'t_inv','t_egress', t_tot, t_w_tot

APx_to_APy_list_total = [['i','ac','ap1','fl','ap2','eg','j','dt','dtw','R','P','pot','pax','pax_ij_tot','marketshare_ij','freq','cb_ap1','cb_ap2','Utility', 'prob. MNL']]
print ''
print 'Extrapolating airport demand to city demand:'
with tqdm(total=len(airport_information), desc="Processing", bar_format="{l_bar}{bar} [ time left: {remaining} ]",position=0, leave=True) as pbar:
    for x in range(len(airport_information)):
        pbar.update(1)
        #for z in tqdm(range(len(airport_information))): #loading bar
        for y in range(len(airport_information)):
            if mirror_matrix[x,y] != ':':
                #lookup for all possible flights
                APx_to_APy_list = [['i','ac','ap1','fl','ap2','eg','j','dt','dtw','R','P','pot','pax','pax_ij_tot','marketshare_ij','freq','cb_ap1','cb_ap2','Utility', 'prob. MNL']]
                for row in range(len(connectivity_list)):
                    if int(float(connectivity_list[row][2])) == int(x) and int(float(connectivity_list[row][4])) == int(y):
                            APx_to_APy_list = np.append(APx_to_APy_list, [connectivity_list[row]], axis=0)
                APx_to_APy_list = np.delete(APx_to_APy_list, 0, axis=0)
                if len(APx_to_APy_list) != 0:
                    sum_potential = 0
                    for trip in range(len(APx_to_APy_list)):
                        sum_potential = sum_potential + float(APx_to_APy_list[trip,11])
                    #print APx_to_APy_list, sum_potential
                    for trip in range(len(APx_to_APy_list)):
                        marketshare = float(APx_to_APy_list[trip,11]) / sum_potential
                        i = int(float(APx_to_APy_list[trip,0])); j = int(float(APx_to_APy_list[trip,6]))
                        #print marketshare, i, j
                        DEMAND_AIR[i,j] = DEMAND_AIR[i,j] + (float(marketshare) * float(mirror_matrix[x,y]))
                        APx_to_APy_list[trip,12] = (float(marketshare) * float(mirror_matrix[x,y]))
                        #Matrix_avg_flight_2[i,j][0] = Matrix_avg_flight_2[i,j][0] + (float(marketshare) * float(APx_to_APy_list[trip,1]))
                        #Matrix_avg_flight_2[i,j][1] = Matrix_avg_flight_2[i,j][1] + (float(marketshare) * t_wait)
                        #Matrix_avg_flight_2[i,j][2] = Matrix_avg_flight_2[i,j][2] + (float(marketshare) * float(APx_to_APy_list[trip,3]))
                        #Matrix_avg_flight_2[i,j][3] = Matrix_avg_flight_2[i,j][3] + (float(marketshare) * float(APx_to_APy_list[trip,5]))
                APx_to_APy_list_total = np.append(APx_to_APy_list_total, APx_to_APy_list, axis=0)
APx_to_APy_list_total = np.delete(APx_to_APy_list_total, 0, axis=0)                

#print ''
print round(DEMAND_AIR[109,122],0), V[109], V[122]
print round(DEMAND_AIR[110,122],0), V[110], V[122]
print round(DEMAND_AIR[111,122],0), V[111], V[122]
print round(DEMAND_AIR[112,122],0), V[112], V[122]
print round(DEMAND_AIR[113,122],0), V[113], V[122]

for row in range(len(APx_to_APy_list_total)):
    APx_to_APy_list_total[row][13] = DEMAND_AIR[int(APx_to_APy_list_total[row][0]), int(APx_to_APy_list_total[row][6])]
    APx_to_APy_list_total[row][14] = float(APx_to_APy_list_total[row][12]) / float(APx_to_APy_list_total[row][13])

for row in range(len(APx_to_APy_list_total)):
    i = int(APx_to_APy_list_total[row][0])
    j = int(APx_to_APy_list_total[row][6])
    marketshare_ixyj = float(APx_to_APy_list_total[row][14])
    Matrix_avg_flight_2[i,j][0] = Matrix_avg_flight_2[i,j][0] + (marketshare_ixyj * float(APx_to_APy_list_total[row,1]))
    Matrix_avg_flight_2[i,j][1] = Matrix_avg_flight_2[i,j][1] + (marketshare_ixyj * t_wait)
    Matrix_avg_flight_2[i,j][2] = Matrix_avg_flight_2[i,j][2] + (marketshare_ixyj * float(APx_to_APy_list_total[row,3]))
    Matrix_avg_flight_2[i,j][3] = Matrix_avg_flight_2[i,j][3] + (marketshare_ixyj * float(APx_to_APy_list_total[row,5]))

for i in range_len_V:
    for j in range_len_V:
        Matrix_avg_flight_2[i,j][4] = Matrix_avg_flight_2[i,j][0] + Matrix_avg_flight_2[i,j][1] + Matrix_avg_flight_2[i,j][2] + Matrix_avg_flight_2[i,j][3]
        Matrix_avg_flight_2[i,j][5] = func_t_trip_air_weighted(Matrix_avg_flight_2[i,j][0], Matrix_avg_flight_2[i,j][1], Matrix_avg_flight_2[i,j][2], Matrix_avg_flight_2[i,j][3])

for i in range_len_V:
    for j in range_len_V:
        if np.sum(Matrix_avg_flight_2[i,j]) < 0.00001:
            Matrix_avg_flight_2[i,j] = [float('inf'),float('inf'),float('inf'),float('inf'),float('inf'),float('inf')]
        

print '' 
print Matrix_avg_flight_2[109,122]  
print Matrix_avg_flight_2[110,122]   
print Matrix_avg_flight_2[111,122]  
print Matrix_avg_flight_2[112,122]  
print Matrix_avg_flight_2[113,122]   
'''
#export total_matrix to excel
df = pd.DataFrame(DEMAND_AIR)
df.to_excel(excel_writer = "H:/#Afstuderen/Demand_Estimation/DEMAND_AIR.xlsx")     
'''

""""---------------------------------------------------------------------------
--------------------------------     STEP 9.    -------------------------------
------------------------  translation to total demand -------------------------
-----------------------------------------------------------------------------"""
 

print ''
print 'Translate air demand to total demand' 
           
def MS_air_predictor(distance):
    
    if distance <= 200.:
        MS_air = float('inf')
    if distance > 200. and distance < 1300.:
        MS_air =((1.4940581931E-12*distance**4) - (4.7257341849021E-09*distance**3) + (4.59662481788692E-6*distance**2) - (5.0276000274593E-4*distance))
    if distance >= 1300.:
        MS_air = 1.00
    
    return MS_air

DEMAND_TOTAL = np.zeros((length_V, length_V))
for i in range_len_V:
    for j in range_len_V:
        if i != j:
            DEMAND_TOTAL[i,j] = DEMAND_AIR[i,j] / MS_air_predictor(road_distance[i,j])
            #tt_air  = Matrix_avg_flight_2[i,j][5]
            #tt_car  = func_t_trip_car_estimated( i, j    )
            #if i == 109 and j == 122:
                #print 'v_i v_j   |   MSair MSair   |   air car PT'
                #print i,j, '  |  ' , round(MS_air_predictor(road_distance[i,j]),3), round(MS_air_estimate,3), '  |  ' , round(tt_air,2), round(tt_car,2)
            #if i == 110 and j == 122:
                #print i,j, '  |  ' , round(MS_air_predictor(road_distance[i,j]),3), round(MS_air_estimate,3), '  |  ' , round(tt_air,2), round(tt_car,2)
            #if i == 111 and j == 122:
                #print i,j, '  |  ' , round(MS_air_predictor(road_distance[i,j]),3), round(MS_air_estimate,3), '  |  ' , round(tt_air,2), round(tt_car,2)
            #if i == 112 and j == 122:
                #print i,j, '  |  ' , round(MS_air_predictor(road_distance[i,j]),3), round(MS_air_estimate,3), '  |  ' , round(tt_air,2), round(tt_car,2)
            #if i == 113 and j == 122:
                #print i,j, '  |  ' , round(MS_air_predictor(road_distance[i,j]),3), round(MS_air_estimate,3), '  |  ' , round(tt_air,2), round(tt_car,2)            
            #print round(DEMAND_TOTAL[i,j]), round(DEMAND_AIR[i,j]), MS_air_predictor(road_distance[i,j])
#'''
#export total_matrix to excel
df = pd.DataFrame(DEMAND_TOTAL)
df.to_excel(excel_writer = "H:/#Afstuderen/Demand_Estimation/DEMAND_TOTAL.xlsx")     
          

print ''
print round(DEMAND_TOTAL[109,122]), V[109], V[122]
print round(DEMAND_TOTAL[110,122]), V[110], V[122]
print round(DEMAND_TOTAL[111,122]), V[111], V[122]
print round(DEMAND_TOTAL[112,122]), V[112], V[122]
print round(DEMAND_TOTAL[113,122]), V[113], V[122] 
 
#'''

""""---------------------------------------------------------------------------
--------------------------------     STEP E.    -------------------------------
----------------------------  Evaluating the fittnes --------------------------
-----------------------------------------------------------------------------"""

Matrix_avg_flight_3 = np.zeros((length_V, length_V), dtype=object)
#print Matrix_avg_flight[109,122]

for i in range_len_V:
    for j in  range_len_V:
        Matrix_avg_flight_3[i,j] = Matrix_avg_flight_2[i,j][5]
#print Matrix_avg_flight_3[109,122]

matrix_squared_diff =  np.zeros((length_V, length_V), dtype=object)
for i in range_len_V:
    for j in  range_len_V:
        if Matrix_avg_flight_3[i,j] == float('inf') and Matrix_avg_flight[i,j] == float('inf'):
            Matrix_avg_flight_3[i,j] = 99999; Matrix_avg_flight[i,j] = 99999
        matrix_squared_diff[i,j] = (((Matrix_avg_flight_3[i,j] - Matrix_avg_flight[i,j]) / Matrix_avg_flight[i,j]) * DEMAND_AIR[i,j])**2
        if math.isnan(matrix_squared_diff[i,j]):
            matrix_squared_diff[i,j] = 0

np.set_printoptions(suppress=True)            
#fitting_result[fitting_iteration][0] = a1
#fitting_result[fitting_iteration][1] = a2
#fitting_result[fitting_iteration][2] = a3
#fitting_result[fitting_iteration][3] = np.sum(matrix_squared_diff)

""""---------------------------------------------------------------------------
--------------------------------     STEP 10.    ------------------------------
--------------------------------   Finalisation  ------------------------------
-----------------------------------------------------------------------------"""

for music in range(2):
    playmusic =  music
    duration = 500  # milliseconds
    freq = 261  # Hz
    winsound.Beep(freq, duration)
    time.sleep(0.5)
    duration = 500  # milliseconds
    freq = 329  # Hz
    winsound.Beep(freq, duration)
    time.sleep(0.5)
    duration = 500  # milliseconds
    freq = 392  # Hz
    winsound.Beep(freq, duration)
    time.sleep(1)

